/**
* \file: ICarPlayDeviceAdapter.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: Pradeepa Govindaraju / ADIT/SW1 /
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef ICARPLAYDEVICEADAPTER_H_
#define ICARPLAYDEVICEADAPTER_H_



namespace adit { namespace carplay
{


struct CarPlayDevice
{
    char *deviceName;
    char *btMac;
    char *deviceVersion;
};

typedef enum
{
    CarPlayAdapterError_NoError                     =  0,
    CarPlayAdapterError_ActiveSession               = -1,
    CarPlayAdapterError_ParamErr                    = -2,
    CarPlayAdapterError_Generic                     = -3
}CAEStatus;


/**
 * Interface provided by CarPlay.
 */
class ICarPlayDeviceReceiver
{
public:
    virtual ~ICarPlayDeviceReceiver() {};

    virtual CAEStatus StartCarPlayDeviceDiscovery() = 0;

    virtual CAEStatus StopCarPlayDeviceDiscovery() = 0;

    virtual CAEStatus ConnectDevice(const char *btMacId) = 0;

    virtual CAEStatus DeviceLeftFromAP(const char *btMacId, const char* ipAddress) = 0;

    virtual CAEStatus DisconnectDevice(const char *btMacId) = 0;
};

/**
 * Interface to be implemented by the adapter.
 */
class ICarPlayDeviceAdapter
{
public:
    /**
     * Default virtual destructor.
     * Gets called when a Session is destroyed.
     */
    virtual ~ICarPlayDeviceAdapter() {};

    virtual bool Initialize(ICarPlayDeviceReceiver& receiverDevice) = 0;

    virtual void OnDeviceUpdated(const CarPlayDevice& deviceCarplay,bool inStatus) = 0;
};

} } /* namespace adit { namespace carplay */

#endif /* CARPLAY_ICARPLAYDEVICEADAPTER_H_ */
